<?php
/*
  This plugin uses a modified version of free CAPTCHA class licensed under GPL. Its homepage is:
    http://www.phpclasses.org/package/3336-PHP-Generate-CAPTCHA-validation-images.html
  Also, this plugin requires a font file named captcha.ttf in your config folder.
*/

  BEvent::Hook('normalize comment', array('BlogCAPTCHA', 'Check'));
  BEvent::Hook('on tpl vars: commenting', array('BlogCAPTCHA', 'AddFieldTo'));

  BConfig::$strings['captcha: caption'] = 'Which letters (%s) you see here?';

  $path = &BlogCAPTCHA::$imagePath;
  $path = ToAbsolutePath( rtrim($path, '\\/').'/' );
  $url = &BlogCAPTCHA::$imageURL;
  $url = ToAbsoluteURL(rtrim($url, '\\/').'/', BConfig::$engineURL);

/* one-shot */
  $this->name = 'captcha';
  $this->Caption('CAPTCHA');
  $this->info['user files'] = array('BlogCAPTCHA', 'UserFiles');
/* install BlogCAPTCHA */
class BlogCAPTCHA {
  static $imagePath = 'cache/captcha';
  static $imageURL = 'cache/captcha';

  const Length = 5;
  const CleanUpChance = 5;  // 5% to clean up dir with generated images on each page request.

  static function KeyFor($str) { return md5( BConfig::$secret.strtolower(" $str") ); }

  static function Check($parent, $comment, &$info) {
    if (self::KeyFor($info['captcha']) !== $info['captchaKey']) {
      throw new BException('The letters you\'ve entered differ from the ones we\'ve shown you on the image.');
    }
  }

  static function AddFieldTo(&$vars, $varPrefix) {
    list($image, $phrase) = self::Generate();

    $image = BConfig::$engineURL.rtrim(self::$imageURL, '\\/')."/$image";
    $value = '<input type="text" name="captcha" /><br /><img src="'.$image.'" alt="CAPTCHA" />';

    $vars[$varPrefix.'Query']['captchaKey'] = self::KeyFor($phrase);
    $vars[$varPrefix.'Fields'][] =
      array('type' => 'captcha', 'value' => $value,
            'caption' => Translate('captcha: caption', self::Length));
  }

  static function Generate() {
    static $image, $phrase;

    if (!$image) {
      $phrase = self::GeneratePhrase();

      $path = rtrim(self::$imagePath, '\\/').'/';
      EnsureDirExists($path);

      $generator = new Captcha($phrase, $path);
      $generator->font = BConfig::FileOf('config', 'captcha.ttf');
      if (!is_file($generator->font)) {
        throw new BException('Font file '.$generator->font.' for CAPTCHA generation wasn\'t found.');
      }

      $image = $generator->createCaptcha();
      if (!is_file($image)) {
        throw new BException('CAPTHCA generation failed: file '.$image.' wasn\'t created.');
      }

      if (mt_rand(0, 99) <= self::CleanUpChance) { self::CleanUp(self::$imagePath); }
    }

    return array(basename($image), $phrase);
  }

    static function GeneratePhrase() {
      return join( array_rand(array_flip(range('A', 'Z')), self::Length) );
    }

  static function CleanUp($path) {
    $path = rtrim($path, '\\/').'/';
    $files = glob("$path*.{png,jpg}", GLOB_BRACE | GLOB_NOSORT);

    $maxAge = time() - 24 * 3600;
    foreach ($files as $file) {
      if (filemtime($file) < $maxAge) { unlink($file); }
    }
  }

  static function UserFiles() {
    return array(self::$imagePath, BConfig::FileOf('config', 'captcha.ttf'));
  }
}


  /******************************************************************

   Projectname:   CAPTCHA 2
   Version:	  0.9
   Author:        Cristian Navalici cristian.navalici at gmail dot com
   Last modified: 22-feb-2007
   Copyright (C): 2007 Cristian Navalici, All Rights Reserved

   * GNU General Public License (Version 2, June 1991)
   *
   * This program is free software; you can redistribute
   * it and/or modify it under the terms of the GNU
   * General Public License as published by the Free
   * Software Foundation; either version 2 of the License,
   * or (at your option) any later version.
   *
   * This program is distributed in the hope that it will
   * be useful, but WITHOUT ANY WARRANTY; without even the
   * implied warranty of MERCHANTABILITY or FITNESS FOR A
   * PARTICULAR PURPOSE. See the GNU General Public License
   * for more details.

   Description:
   This class can generate CAPTCHAs, see README for more details!

   28.02.2007 - added Windows specifications for MCRYPT_RAND

  ******************************************************************/

class Captcha {

  // here you can make some adjustments
  private $font_size 	= 24; // if GD2 in points / GD1 in pixels
  public $font 		= 'captcha.ttf';
  private $img_height 	= 70;
  private $save_path	= 'gdtest'; // without trailing slash

  private $allow_jpg_output = false;
  private $allow_png_output = false;
  private $phrase;

  //======================================================================
  //	CONSTRUCTOR
  //======================================================================
  function __construct ($phrase, $save_path) {
    $this->phrase = $phrase;
    $this->save_path = $save_path;

    $check_gd = gd_info();
    $this->allow_jpg_output = !empty($check_gd['JPG Support']) || !empty($check_gd['JPEG Support']);
    $this->allow_png_output = !empty($check_gd['PNG Support']);
  }

  //======================================================================
  // MAIN FUNCTION: createCaptcha
  // create a captcha image based on supplied arguments
  // if GD is not enabled it switch to TEXT MODE
  //
  // @arg:	$length (int) - length of generated string
  //		$type (string) - type of generated picture (jpg or png)
  //		$draw_lines (bool) - optional lines on picture
  // @return:	none (picture saved)
  //======================================================================
  public function createCaptcha($type = 'png', $draw_lines = true) {
  $length = strlen($this->phrase);

    $img_length = $length * ($this->font_size+5);
    $image       = imagecreatetruecolor($img_length, $this->img_height) or die("Cannot Initialize new GD image stream");;

    //  ----- TRANSFORMATIONS PART -----------------------------------
    // set background
    $bgcolor     = imagecolorallocate($image, 255, 255, 255);
    imagefill($image,0,0,$bgcolor);

    $random_pixels = $img_length * $this->img_height / 2;

    for ($i = 0; $i < $random_pixels; $i++) {
      $color_pixel  = ImageColorAllocate($image, mt_rand(0, 255), mt_rand(0, 255), mt_rand(0, 255));
      ImageSetPixel($image, rand(0, $img_length), rand(0, $this->img_height), $color_pixel);
    }

    // smooth image
    imagefilter($image, IMG_FILTER_SMOOTH, 10);

    // add text
    $gens = $this->phrase;
    for ($i = 0 ; $i < $length ; $i++) {
      $stringcolor = imagecolorallocate($image, mt_rand(0, 180), mt_rand(0, 100), mt_rand(0, 180));
      imagettftext($image, $this->font_size, mt_rand(-40,40), 10 + (($this->font_size + 4) * $i), mt_rand(40, 60),
                   $stringcolor,
                   $this->font,
                   $gens{$i});
    }

    // default draw lines
    if ((bool)$draw_lines) {
      $img = $this->drawLines ($image, $img_length);
    } else {
      $img = $image;
    }

    //  ----- EOS TRANSFORMATIONS PART -----------------------------------

    //create name for saved files (must be unique)
    $i = count(glob($this->save_path .'/*'));
    while (is_file($sname = $this->save_path .'/'. $i++)) { }

    // if you want a jpeg or png but the option is not available
    // automated change to the other type
    if ((!$this->allow_jpg_output) && (!$this->allow_png_output)) {
      throw new BException("CAPTHA generation failed: no support for jpg or png. Check your GD configuration.");
    } else {
      if ($type == 'jpeg') {
        if ($this->allow_jpg_output) {
          $sname .= '.jpg';
                imagejpeg($img, $sname);
              } else {
                $sname .= '.png';
                imagepng($img, $sname);
              }
      } elseif ($type == 'png') {
              if ($this->allow_png_output) {
                $sname .= '.png';
                imagepng($img, $sname);
              } else {
          $sname .= '.jpg';
                imagejpeg($img, $sname);
              }
      }
    } // if-else

    imagedestroy($img);
    return $sname;

  }

  //============================================================================================
  //	P R I V A T E    F U N C T I O N S
  //============================================================================================

  //======================================================================
  // DRAW SOME LINES ON PICTURE
  // draw some lines to image to make it more complicated
  //
  // @arg:	$image (resource)
  //		$imagelength (int)
  // @return:	$image (resource) - an image painted with lines
  //======================================================================
  private function drawLines($image, $imagelength) {

    for ($i =0 ; $i<4 ; $i++) {
      // define random colors  for lines
      $cColor = imagecolorallocate($image,mt_rand(0,255),mt_rand(0,255),mt_rand(0,255));

      // first coodinates are in the first half of image
      $x0coordonate = mt_rand (0, 0.5 * $imagelength);
      $y0coordonate = mt_rand (0, $this->img_height);
      // second coodinates are in the second half of image
      $x1coordonate = mt_rand (0.5 * $imagelength,$imagelength);
      $y1coordonate = mt_rand (0, $this->img_height);

      imageline ($image, $x0coordonate, $y0coordonate, $x1coordonate, $y1coordonate,$cColor );
      imageline ($image, $x0coordonate-1, $y0coordonate-1, $x1coordonate-1, $y1coordonate-1,$cColor );
    }

    return $image;
  }


} // EOF class
